#include "administratorpasswordinputforuksecuritydialog.h"
#include "ui_administratorpasswordinputforuksecuritydialog.h"
#include <QTimer>

AdministratorPasswordInputForUKSecurityDialog::AdministratorPasswordInputForUKSecurityDialog(QWidget *parent) : QDialog(parent),
                                                                                                                ui(new Ui::AdministratorPasswordInputForUKSecurityDialog)
{
    m_password = "";
    ui->setupUi(this);
    this->setFixedSize(this->size());
    ui->HyperLink_label->setText(QApplication::translate("AdministratorPasswordInputForUKSecurityDialog", "<a href='https://support.epson.net/manu/adminpw/index.html'>https://support.epson.net/manu/adminpw/index.html</a>", 0));
    ui->HyperLink_label->setTextFormat(Qt::RichText);  // HTML化する
    ui->HyperLink_label->setTextInteractionFlags(Qt::TextBrowserInteraction);  // テキストをクリック可能にする
    ui->HyperLink_label->setOpenExternalLinks(true);  // 外部リンクを開く許可

    QTimer::singleShot(0, ui->Password_Input_lineEdit, SLOT(setFocus()));
    setWindowFlags(Qt::WindowTitleHint | Qt::Window | Qt::CustomizeWindowHint | Qt::WindowStaysOnTopHint);
}

AdministratorPasswordInputForUKSecurityDialog::~AdministratorPasswordInputForUKSecurityDialog()
{
    delete ui;
}

void AdministratorPasswordInputForUKSecurityDialog::PushButtonAction(void)
{
    QObject *obj = sender();
    
    if (obj == ui->OK_pushButton)
    {
        m_password = ui->Password_Input_lineEdit->text();
        this->reject();
    }
    else if (obj == ui->Cancel_pushButton)
    {
        m_password = "";
        this->reject();
    }
}

void AdministratorPasswordInputForUKSecurityDialog::closeEvent(QCloseEvent *event)
{
    event->ignore();
}

void AdministratorPasswordInputForUKSecurityDialog::LineEditFinished()
{
    //アドレスのエディットボックスが空のとき追加ボタンをグレーアウト
    if (ui->Password_Input_lineEdit->text() != "")
    {
        ui->OK_pushButton->setEnabled(true);
    }
    else
    {
        ui->OK_pushButton->setEnabled(false);
    }
}

QString AdministratorPasswordInputForUKSecurityDialog::GetPassword()
{
    return m_password;
}
